/*
 * Carrega.java
 *
 * Created on 10 de junio de 2008, 15:41
 */

package servlets;

import entitats.Client;
import java.io.*;
import java.net.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;
import locals.Local;
import locals.Zona;

/**
 *
 * @author dai
 * @version
 */
public class Carrega extends HttpServlet {
    
    Connection con = null;
    DataSource ds = null;
    Statement st = null;
    
    ArrayList <Local> locals = new ArrayList();
    ArrayList <Zona> zones = new ArrayList();
    ArrayList <Client> clients = new ArrayList();
    ArrayList <Local> immobles = new ArrayList();
    ArrayList <Local> localsImmoble = new ArrayList();
    ArrayList <Local> localsLliures = new ArrayList();
    
    Local local = new Local();
    Zona zona = new Zona();
    Client client = new Client();
    
    RequestDispatcher rD = null;
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        
        try {
            //Agafa la conexio
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
            con = ds.getConnection();
            st = con.createStatement();
            
            //Neteja els ArrayLists
            locals.clear();
            zones.clear();
            clients.clear();
            
            
            //Comprova els parametres que li arriba per tal de carregar el que se li demana
            if (request.getParameter("client") != null)
                if (request.getParameter("client").equals("1")) {
                carregaClients(request);
                request.setAttribute("Client", clients);
                }
            
            if (request.getParameter("clients") != null)
                if (request.getParameter("clients").equals("1")) {
                carregaClients(request);
                request.setAttribute("clients", clients);
                }
            
            if (request.getParameter("zones") != null)
                if (request.getParameter("zones").equals("1")) {
                carregaZones();
                request.setAttribute("zones", zones);
                }
            
            if (request.getParameter("id_zona") != null) {
                carregaZona(Integer.parseInt(request.getParameter("id_zona")));
                request.setAttribute("Zona", zona);
            }
            
            if (request.getParameter("idlocal") != null) {
                carregaLocal(Integer.parseInt(request.getParameter("idlocal")));
                request.setAttribute("Local", local);
            }
            
            if (request.getParameter("locals") != null) {
                carregaLocals(Integer.parseInt(request.getParameter("locals")));
                request.setAttribute("locals", locals);
            }
            
            if (request.getParameter("locals_sense_contracte") != null)
                if (request.getParameter("locals_sense_contracte").equals("1")) {
                carregaLocalsSenseContracte();
                request.setAttribute("locals", locals);
                }
            
            if (request.getParameter("immobles") != null)
                if (request.getParameter("immobles").equals("1")){
                immobles.clear();
                request.getSession().removeAttribute("immboles");
                carregaImmobles();
                request.getSession().setAttribute("immobles", immobles);
                }
            
            if (request.getParameter("locals_lliures") != null)
                if (request.getParameter("locals_lliures").equals("1")){
                localsLliures.clear();
                request.getSession().removeAttribute("locals_lliures");
                carregaLocalsLliures();
                request.getSession().setAttribute("localsLliures", localsLliures);
                }
            
            if (request.getParameter("idLocal") != null){
                localsImmoble.clear();
                request.getSession().removeAttribute("idLocal");
                carregaLocalsImmoble(Integer.parseInt(request.getParameter("idLocal")));
                request.getSession().setAttribute("localsImmoble", localsImmoble);
            }
            
            //Fa els redirect depenent de l'accio que es vulgui realitzar
            if (request.getParameter("action") != null){
                
                if (request.getParameter("action").equals("baixa_propietari"))
                    rD = request.getRequestDispatcher("/baixa_client.jsp");
                
                if (request.getParameter("action").equals("edicio_client"))
                    rD = request.getRequestDispatcher("/modificacio_client.jsp");
                
                if (request.getParameter("action").equals("alta_local"))
                    rD = request.getRequestDispatcher("/alta_local.jsp");
                
                if (request.getParameter("action").equals("baixa_local"))
                    rD = request.getRequestDispatcher("/baixa_local.jsp");
                
                if (request.getParameter("action").equals("aprovar_local"))
                    rD = request.getRequestDispatcher("/aprovar_local.jsp");
                
                if (request.getParameter("action").equals("modificar_local"))
                    rD = request.getRequestDispatcher("/modificacio_local.jsp");
                
                if (request.getParameter("action").equals("alta_llogater"))
                    rD = request.getRequestDispatcher("/alta_propietari.jsp");
                
                if (request.getParameter("action").equals("afegir_locals"))
                    rD = request.getRequestDispatcher("/afegir_locals.jsp");
                
                if (request.getParameter("action").equals("contracte"))
                    rD = request.getRequestDispatcher("/contracte.jsp");
                
                if (request.getParameter("action").equals("modificacio_zona"))
                    rD = request.getRequestDispatcher("/modificacio_zona.jsp");
                
                if (request.getParameter("action").equals("baixa_zona"))
                    rD = request.getRequestDispatcher("/baixa_zona.jsp");
            }
            
            rD.forward(request, response);
            out.close();
            
        } catch(Exception e) {
            rD = request.getRequestDispatcher("/error.jsp");
            request.setAttribute("error", e.getMessage());
            rD.forward(request, response);
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){
                rD = request.getRequestDispatcher("/error.jsp");
                rD.forward(request, response);
            }
        }
    }
    
    
    /*Metodes de carrega*/
    
    //Carrega totes les zones disponibles a la base de dades
    protected void carregaZones() throws Exception {
        ResultSet rs = st.executeQuery("SELECT * FROM zones");
        while ( rs.next() ) {
            zones.add(new Zona(rs.getInt("id"), rs.getString("zona"), rs.getString("descripcio")));
        }
    }
    
    //Carrega tots els clients (propietaris o llogaters depenent), tambe conte dins la carrega d'un sol client.
    protected void carregaClients(HttpServletRequest request) throws Exception {
        ResultSet rs = null;
        String idClient = request.getParameter("id");
        Client c = new Client();
        c = (Client) request.getAttribute("Client");
        
        //Omple els camps del client que es podran modificar
        if (request.getParameter("id") != null && Integer.parseInt(request.getParameter("id")) > 0){
            rs = st.executeQuery("SELECT * FROM clients WHERE id = "+idClient);
            rs.next();
            Client client = new Client();
            client.setIdClient(rs.getInt("id"));
            client.setNif(rs.getString("nif"));
            client.setNom(rs.getString("nom_o_rao_social"));
            if (rs.getString("cognoms") != null)
                client.setCognoms(rs.getString("cognoms"));
            client.setTelefon(rs.getString("telefon"));
            client.setAdresa(rs.getString("adresa"));
            if (request.getAttribute("Client") != null)
                client.setError(c.getError());
            request.setAttribute("Client", client);
            if (request.getSession().getAttribute("usuarivenedor") != null)
            {
                client.setIdZona(rs.getInt("preferencies_id_zona"));
                client.setTipusLocal(rs.getString("preferencies_tipus_local"));
                client.setSuperficieMinima(rs.getFloat("preferencies_superficie_minima"));
            }
        }
        
        //Comprova si hi ha algun atribut clients, i si no hi es omple un arraylist per mostrar tots els clients
        Client client = new Client();
        if (request.getSession().getAttribute("usuariagent") != null)
            rs = st.executeQuery("SELECT * FROM clients WHERE es_propietari = 1");
        else if (request.getSession().getAttribute("usuarivenedor") != null)
            rs = st.executeQuery("SELECT * FROM clients WHERE es_llogater = 1");
        while (rs.next()) {
            clients.add(new Client(rs.getInt("id"), rs.getString("nif"), rs.getString("nom_o_rao_social"), rs.getString("cognoms")));
        }
    }
    
    protected void carregaZona(int idZona) throws Exception {
        ResultSet rs = st.executeQuery("SELECT * FROM zones WHERE id = "+idZona);
        if ( rs.next() ) {
            zona.setZona(rs.getString("zona"));
            zona.setDescripcio(rs.getString("descripcio"));
        }
    }
    
    //Carrega tots els locals en un ArrayList
    protected void carregaLocals(int actiu) throws Exception {
        
        ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE actiu = "+actiu);
        while ( rs.next() ) {
            locals.add(new Local(rs.getString("codi_local"), rs.getInt("id"), rs.getString("adresa")));
        }
    }
    
    //Carrega la informacio de un sol local
    protected void carregaLocal(int idLocal) throws Exception {
        ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE id = "+idLocal);
        if ( rs.next() ) {
            local.setAdresa(rs.getString("adresa"));
            local.setCaracteristiques(rs.getString("caracteristiques"));
            local.setCaracteristiquesPolivalents(rs.getString("caracteristiques_polivalent"));
            local.setCodiLocal(rs.getString("codi_local"));
            local.setIdLocal(idLocal);
            local.setIdPropietari(rs.getInt("id_propietari"));
            local.setPreu(rs.getFloat("preu"));
            local.setRestriccions(rs.getString("restriccions"));
            local.setSuperficie(rs.getFloat("superficie"));
            local.setTipus(rs.getString("tipus"));
            local.setVolum(rs.getFloat("volum"));
            local.setIdZona(rs.getInt("id_zona"));
            local.setActiu(rs.getBoolean("actiu"));
        }
    }
    
//Carrega tots el immobles disponibles
    protected void carregaImmobles() throws Exception{
        ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE actiu = 1 AND tipus = 'immoble'");
        while ( rs.next() ) {
            immobles.add(new Local(rs.getString("codi_local"), rs.getInt("id"), rs.getString("adresa")));
        }
    }
    
//Carrega tots els locals que conte un immoble
    protected void carregaLocalsImmoble(int idImmoble) throws Exception {
        ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE tipus NOT LIKE 'immoble' AND id IN (SELECT id_local FROM immoble_local WHERE id_immoble = "+idImmoble+")  AND actiu = 1");
        while ( rs.next() ) {
            localsImmoble.add(new Local(rs.getString("codi_local"), rs.getInt("id"), rs.getString("adresa")));
        }
    }
    
//Carrega tots els locals que estan lliures
    protected void carregaLocalsLliures() throws Exception {
        ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE tipus NOT LIKE 'immoble' AND id NOT IN (SELECT id_local FROM immoble_local) AND actiu = 1");
        while ( rs.next() ) {
            localsLliures.add(new Local(rs.getString("codi_local"), rs.getInt("id"), rs.getString("adresa")));
        }
    }
    
    protected void carregaLocalsSenseContracte() throws Exception {
        ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE id NOT IN (SELECT id_local FROM contractes)");
        while ( rs.next() ) {
            locals.add(new Local(rs.getString("codi_local"), rs.getInt("id"), rs.getString("adresa")));
        }
    }
    
// <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        //this.doGet(request, response);
        processRequest(request, response);
        
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
// </editor-fold>
}
